/*

Today Plugin Tester
Copyright (C) 2000 Scott Seligman
<scott@scottandmichelle.net>


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
Today Plugin Tester is a generic test framework to test Today DLL 
plugins.  It should be compatible with any plugin, the plugin will 
either need to be renamed, or the TODAY_DLL_NAME constant will have 
to be changed to match the name/location of the DLL.

ChangeLog:
version 1.0 - Initial Releasen (Scott Seligman)
        1.1 - Added Today-like UI (Gary Niemcewicz)
*/

#include "stdafx.h"
#include "Tester.h"
#include <commctrl.h>
#include <Todaycmn.h>

#define TODAY_DLL_NAME	L"\\Windows\\MyToday.dll"
#define MAX_LOADSTRING	100

HINSTANCE			hInst;
HWND				hwndCB;
HINSTANCE			hlbToday; //The today DLL
TODAYLISTITEM		tli;
HWND				hwndTodayItem;

//
// proto
//

ATOM				MyRegisterClass	(HINSTANCE, LPTSTR);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
void				ShowError		(LPTSTR);

void GetBitmapRect(int & x_dim, int & y_dim, int bitmap_resource);
void PaintBitmap(HINSTANCE hInst, HDC & hdc, int bitmap_resource, int x_pos, int y_pos);
void PaintTodaySimul(HINSTANCE hInst, HWND hWnd);

//
// end proto
//

void ShowError(LPTSTR szError) {
	TCHAR szMessage[2000];
	wsprintf(szMessage, L"%s GetLastError() returns %d", szError, GetLastError());
	MessageBox(0, szMessage, L"Error", MB_ICONEXCLAMATION | MB_TOPMOST);
}

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow) {
	MSG msg;
	HACCEL hAccelTable;

	HWND	hWndFound;
	TCHAR	szTitle[MAX_LOADSTRING];
	TCHAR	szWindowClass[MAX_LOADSTRING];

	LoadString(hInstance, IDC_TESTER, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	hWndFound = FindWindow(szWindowClass, szTitle);
	if (hWndFound) {
		SetForegroundWindow(hWndFound);
		return 0;
	} else {

		if (!InitInstance (hInstance, nCmdShow)) {
			return FALSE;
		}

		hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TESTER);

		while (GetMessage(&msg, NULL, 0, 0)) {
			if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}

		return msg.wParam;
	}
}

ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass) {
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TESTER));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow) {
	HWND	hWnd;
	TCHAR	szTitle[MAX_LOADSTRING];
	TCHAR	szWindowClass[MAX_LOADSTRING];

	hInst = hInstance;

	LoadString(hInstance, IDC_TESTER, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance, szWindowClass);

	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE | WS_CLIPCHILDREN,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

	if (!hWnd) {	
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	if (hwndCB)
		CommandBar_Show(hwndCB, TRUE);

	return TRUE;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	int wmId, wmEvent;

	int top_x_dim, top_y_dim;
	RECT cmd_bar;

	switch (message) {

		case WM_PAINT:

			PaintTodaySimul(hInst, hWnd);

			break;

		case WM_TIMER:
			if (hlbToday) {
				if (SendMessage(hwndTodayItem, WM_TODAYCUSTOM_QUERYREFRESHCACHE, (WPARAM) &tli, NULL)) {

					GetBitmapRect(top_x_dim, top_y_dim, IDB_BITMAP_TOP);
					GetClientRect(hwndCB, &cmd_bar);

					MoveWindow(hwndTodayItem, 0, cmd_bar.bottom+top_y_dim, 240, tli.cyp, FALSE);

					InvalidateRect(hwndTodayItem, NULL, FALSE);
					InvalidateRect(hWnd, NULL, FALSE);
				}
			}
			break;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 

			switch (wmId) {
				case IDM_FILE_LOAD: {
					hlbToday = LoadLibrary(TODAY_DLL_NAME);
					if (hlbToday == NULL) {
						ShowError(L"Unable to load DLL.");
						return false;
					}
					static HWND (APIENTRY *pfnInitCustom)(TODAYLISTITEM*, HWND) = NULL;
					pfnInitCustom = (HWND (APIENTRY *)(TODAYLISTITEM*, HWND))GetProcAddress(hlbToday, (LPTSTR) 240);
					if (pfnInitCustom == NULL) {
						ShowError(L"Unable to find entry point into DLL.");
						return false;
					}

					tli.fEnabled = TRUE;
					tli.hinstDLL = hlbToday;

					hwndTodayItem = pfnInitCustom(&tli, hWnd);
					if (SendMessage(hwndTodayItem, WM_TODAYCUSTOM_QUERYREFRESHCACHE, (WPARAM) &tli, NULL)) {

						GetBitmapRect(top_x_dim, top_y_dim, IDB_BITMAP_TOP);
						GetClientRect(hwndCB, &cmd_bar);

						MoveWindow(hwndTodayItem, 0, cmd_bar.bottom+top_y_dim, 240, tli.cyp, FALSE);
						InvalidateRect(hwndTodayItem, NULL, FALSE);
						InvalidateRect(hWnd, NULL, FALSE);
					}
				}
				break;

				case IDM_FILE_OPTIONS: {
					if (hlbToday == NULL) {
						ShowError(L"The DLL isn't loaded.");
						return false;
					}

					BOOL (APIENTRY *pfnCustomDialog)(HWND, UINT, UINT, LONG) = NULL;
					pfnCustomDialog = (BOOL (APIENTRY *)(HWND, UINT, UINT, LONG))GetProcAddress(hlbToday, (LPTSTR) 241);
					if (pfnCustomDialog == NULL) {
						ShowError(L"Unable to find entry point into DLL.");
						return false;
					}

					InitCommonControls();
					DialogBox(hlbToday, MAKEINTRESOURCE(500), hWnd, pfnCustomDialog);

				}
				break;

				case IDM_FILE_EXIT:

					if (hlbToday) FreeLibrary(hlbToday);
				   DestroyWindow(hWnd);
				   break;
				case ID_HELP_ABOUT:
					MessageBox(hWnd, _T("Today Plugin Tester created by Scott Seligman\n<scott@\n  scottandmichelle.net>"), _T("About"),MB_ICONINFORMATION);
					break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			hwndCB = CommandBar_Create(hInst, hWnd, 1);			
			CommandBar_InsertMenubar(hwndCB, hInst, IDM_MENU, 0);

			SetTimer(hWnd, 1, 1000, NULL);

			//the emulator doesn't always do this
			SetForegroundWindow(hWnd);

			break;
		case WM_DESTROY:
			CommandBar_Destroy(hwndCB);
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

void PaintTodaySimul(HINSTANCE hInst, HWND hWnd)
{
	HDC hdc;
	PAINTSTRUCT ps;

	hdc = BeginPaint(hWnd, &ps);

	// stepping y-offset
	int y_offset = 0;

	//
	// paint the upper bitmap
	//
	RECT cmd_bar; GetClientRect(hwndCB, &cmd_bar);
	y_offset += cmd_bar.bottom;

	PaintBitmap(hInst, hdc, IDB_BITMAP_TOP, 0, y_offset);

	int x_dim, y_dim;
	RECT TodayItem; memset(&TodayItem, 0, sizeof(RECT));
	GetBitmapRect(x_dim, y_dim, IDB_BITMAP_TOP);

	y_offset += y_dim;

	if (hwndTodayItem)
	{
		GetClientRect(hwndTodayItem, &TodayItem);
		y_offset += (TodayItem.bottom - TodayItem.top);
	}
	else
	{
		y_offset--;
	}

	//
	// paint the middle bitmap
	//
	PaintBitmap(hInst, hdc, IDB_BITMAP_MIDDLE, 0, y_offset);

	//
	// paint the bottom, leave whatever is left in the middle - white
	//
	RECT main; memset(&main, 0, sizeof(RECT));
	GetClientRect(hWnd, &main);
	GetBitmapRect(x_dim, y_dim, IDB_BITMAP_BOTTOM);

	PaintBitmap(hInst, hdc, IDB_BITMAP_BOTTOM, 0, main.bottom - y_dim);

	EndPaint(hWnd, &ps);
}

void GetBitmapRect(int & x_dim, int & y_dim, int bitmap_resource)
{
	BITMAP bmp;
	HBITMAP hBitmap = LoadBitmap (hInst, MAKEINTRESOURCE(bitmap_resource));

	GetObject(hBitmap, sizeof(BITMAP), &bmp);

	x_dim = bmp.bmWidth;
	y_dim = bmp.bmHeight;

	DeleteObject(hBitmap);
}

void PaintBitmap(HINSTANCE hInst, HDC & hdc, int bitmap_resource, int x_pos, int y_pos)
{
	BITMAP bmp;

	// create a DC that matches the device
	HDC hdcMem = CreateCompatibleDC(hdc);
	// load up the  image
	HBITMAP hBitmap = LoadBitmap (hInst, MAKEINTRESOURCE(bitmap_resource));
	// select the bitmap into the compatible device context
	HGDIOBJ hOldSel = SelectObject(hdcMem, hBitmap);
	// get the bitmap dimentions from the bitmap
	GetObject(hBitmap, sizeof(BITMAP), &bmp);
	// copy the bitmap image from the memory DC to the screen DC
	BitBlt(hdc, x_pos, y_pos, bmp.bmWidth, bmp.bmHeight, hdcMem, 0, 0, SRCCOPY);
	// clean-up
	SelectObject(hdcMem, hOldSel); DeleteDC(hdcMem); DeleteObject(hBitmap);
}
