/*****************************************************************************
 * File.......: Backlight.cpp
 * Author.....: Richard A. Murphy
 * Date.......: 9/15/00, 1:52:29 PM
 * Notes......: Activate the Light Settings for iPaq PocketPC
 *
 * ==========================================================================
 *                Copyright (c) 2000, Richard A. Murphy
 * ==========================================================================
 *
 *****************************************************************************
 * Source.....: Microsoft Visual C++ PocketPC Version 3.0
 * Tabs.......: 2
 *
 ********************************************************************************
 * VSS Version Control $Revision::                                              $
 *
 * Platform:: iPaq PocketPC WinCE 3.0
 * $Archive::                                                                   $
 * $History::                                                                   $
 *
 ********************************************************************************
 * Detailed Revision Comments (Optional):
 *
 *   Date    Time    Who  - Change Description
 * ========  =====  ===== - =====================================================
 * 9/19/00   19:00   shs  - Moved the iPaq specific code into #ifdefs for ARM, and
 *                          added similiar code for the Casio E-1xx under MIPS
 * 1/29/01   10:00   RAM  - iPaq - Changes for Compaq New OS.
 *
 *******************************************************************************/

#include "stdafx.h"
#include "commctrl.h"

#ifdef ARM
#define BACKLIGHT_EXE		  TEXT("\\Windows\\ctlpnl.exe")
#define BACKLIGHT_PARMS		TEXT("backlight.cpl")
#define BACKLIGHT_CLASS		TEXT("CPL_Backlight")
#define BACKLIGHT_WINDOW	TEXT("")
#endif

#ifdef MIPS
#define BACKLIGHT_EXE		  TEXT("\\Windows\\contrast.exe")
#define BACKLIGHT_PARMS		TEXT("")
#define BACKLIGHT_CLASS		TEXT("Dialog")
#define BACKLIGHT_WINDOW	TEXT("Brightness Properties")
#endif

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
  HWND  hAppWnd;
  PROCESS_INFORMATION stProcess;
  DWORD dwExitCode = STILL_ACTIVE;
  TCHAR   szProcess[128],
          szParameters[128] = { 0 };

#ifdef ARM
  HANDLE  hFile;
  WIN32_FIND_DATA stFindFileData;

  /************************************************************
   * Find out what executable to use to start the Backlight
   * Control Panel. The original OS (1.28.00, 5/12/00) used
   * a Control Panel Applet "backlight.cpl" for the Backlight
   * Settings Dialog.  The newer OS (1.69.00, 12/26/00) uses
   * "backlight.exe".
   ***********************************************************/
  hFile = FindFirstFile(TEXT("\\Windows\\backlight.cpl"), &stFindFileData);
  if ( hFile != (HANDLE *) INVALID_HANDLE_VALUE )
  {
    /* Original ROM 5/12/00 -- Using Control Panel Applet */
    wcscpy(szProcess,     TEXT("\\Windows\\ctlpnl.exe"));
    wcscpy(szParameters,  TEXT("backlight.cpl"));
    FindClose(hFile);
  }
  else
  {
    /* New ROM 12/26/00 -- Using Backlight Executable */
    wcscpy(szProcess,     TEXT("\\Windows\\backlight.exe"));
  }
#endif

#ifdef MIPS
    wcscpy(szProcess,     BACKLIGHT_EXE);
    wcscpy(szParameters,  BACKLIGHT_PARMS);
#endif

  /* Execute the Program */
  CreateProcess(szProcess,
                szParameters,
                NULL,                   // Process - NS
                NULL,                   // Thread - NS
                NULL,                   // Inherit Handles - NS
                CREATE_NEW_CONSOLE,     // Flags.
                NULL,                   // Environment - NS
                NULL,                   // Current Dir - NS
                NULL,                   // Start Info - NS
                &stProcess);            // Process Information Structure

  /* Get the Application's Window Handle */
  while ( ((hAppWnd = FindWindow(BACKLIGHT_CLASS, BACKLIGHT_WINDOW)) == NULL)
          && (dwExitCode == STILL_ACTIVE) )
  {
    /* Check the State of the New Process just in Case of an Error */
    if ( !GetExitCodeProcess(stProcess.hProcess, &dwExitCode) )
      break;
  }

#ifdef ARM
  /************************************************************
   * The command to send to "CPL_Backlight" was copied from
   * using Remote SPY++ on the "CPL_Backlight" window when
   * choosing "Backlight" from the QUtilities Icon.
   *
   * In future versions, if this program does not work, use
   * the same method to get the new command to send.
   ***********************************************************/    
  PostMessage(hAppWnd, WM_COMMAND, 0x0002040B, 0);
#endif

#ifdef MIPS
  //If it were only that easy for casio's setup.
  TabCtrl_SetCurSel(GetDlgItem(hAppWnd, 0x6C), 1);

  NMHDR nmhdr;
  nmhdr.hwndFrom = GetDlgItem(hAppWnd, 0x6C);
  nmhdr.idFrom = 0x6C;
  nmhdr.code = TCN_SELCHANGING;
  SendMessage(hAppWnd, WM_NOTIFY, 0x6C, (LPARAM) &nmhdr);

  nmhdr.code = TCN_SELCHANGE;
  SendMessage(hAppWnd, WM_NOTIFY, 0x6C, (LPARAM) &nmhdr);
#endif

  /* Close the Thread and Process Handles */
  CloseHandle(stProcess.hProcess);
  CloseHandle(stProcess.hThread);

	return 0;
}

/* EOF: Backlight.cpp */